@echo off

set device=0

rmdir /s /q tmp

:while
	mkdir tmp
	
	if not %device% == 0 (
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device%p -U signature:r:tmp\signature%device%:i
		
		if not exist tmp\signature%device% (
			set device=0
		)
	)
	
	if %device% == 0 (
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m48p -U signature:r:tmp\signature48:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m88p -U signature:r:tmp\signature88:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m168p -U signature:r:tmp\signature168:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m328p -U signature:r:tmp\signature328:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m164p -U signature:r:tmp\signature164:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m324p -U signature:r:tmp\signature324:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m644p -U signature:r:tmp\signature644:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m1284p -U signature:r:tmp\signature1284:i
		
		if exist tmp\signature48 (
			set device=48
		) else if exist tmp\signature88 (
			set device=88
		) else if exist tmp\signature168 (
			set device=168
		) else if exist tmp\signature328 (
			set device=328
		) else if exist tmp\signature164 (
			set device=164
		) else if exist tmp\signature324 (
			set device=324
		) else if exist tmp\signature644 (
			set device=644
		) else if exist tmp\signature1284 (
			set device=1284
		) else (
			set device=0
		)
	)
	
	if not %device% == 0 (
		echo #define _ATMEGA%device%P>tmp\tmp
		
		for %%f in (*.cpp) do (
			if exist "%%f" (
				type tmp\tmp "%%f">tmp\tmp.cpp
				
				cls
				
				if %device% == 48 (
					echo Compiling and uploading %%f to MODULABLE 20 with ATmega%device%P :
				) else if %device% == 88 (
					echo Compiling and uploading %%f to MODULABLE 20 with ATmega%device%P :
				) else if %device% == 168 (
					echo Compiling and uploading %%f to MODULABLE 20 with ATmega%device%P :
				) else if %device% == 328 (
					echo Compiling and uploading %%f to MODULABLE 20 with ATmega%device%P :
				) else (
					echo Compiling and uploading %%f to MODULABLE 32 with ATmega%device%P :
				)
				
				avr-gcc tmp\tmp.cpp -mmcu=atmega%device%p -I ..\module -Wall -Wextra -Os -ffunction-sections -fdata-sections -Wl,--gc-sections -std=c++11 -o tmp\tmp.elf
				
				if exist tmp\tmp.elf (
					avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device%p -e -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0xfc:m
					avr-objcopy tmp\tmp.elf -O ihex tmp\tmp.hex
					avrdude -P /dev/COM1 -c usbasp -p m%device%p -U flash:w:tmp\tmp.hex:i
					avr-size tmp\tmp.elf -d
				)
			)
		)
	)
	
	rmdir /s /q tmp
	
	pause
	cls
goto while

exit 0
